int portnum = 12000;
int numpts = 7;

import oscP5.*;
import netP5.*;

OscP5 oscP5;
NetAddress myRemoteLocation;

FloatList theta = new FloatList();
FloatList phi = new FloatList();
FloatList radius = new FloatList();

float tadd;
float tnoise = random(1000);
float padd;
float pnoise = random(1000);

float xadd;
float xnoise = random(1000);
float yadd;
float ynoise = random(1000);
float zadd;
float znoise = random(1000);

///camera varibles
int oldx = mouseX;
int oldy = mouseY;
float rotx = 0;
float roty = 0;
float zcam = 0;

void setup(){
  size(600,600,P3D);
  
  oscP5 = new OscP5(this,6000);
  
  myRemoteLocation = new NetAddress("127.0.0.1",portnum);
  
  for(int i = 0; i < numpts; i++){
    theta.append(random(PI*2));
    phi.append(random(PI*2));
    radius.append(random(5,80));
  }
}

void draw(){
  background(0);
  
  tadd = map(noise(tnoise),0,1,-1,1)*PI;
  tnoise = tnoise + 0.005;
  
  padd = map(noise(pnoise),0,1,-1,1)*PI;
  pnoise = pnoise + 0.005;
  
  xadd = map(noise(xnoise),0,1,-1,1)*400;
  xnoise = xnoise + 0.005;
  
  yadd = map(noise(ynoise),0,1,-1,1)*400;
  ynoise = ynoise + 0.005;
  
  zadd = map(noise(znoise),0,1,-1,1)*400;
  znoise = znoise + 0.005;
  
  
  cam();
  
  OscMessage myMessage = new OscMessage("/vicon/frame");
  myMessage.add(frameCount);
  myMessage.add(100);
  
  for(int i = 0; i < theta.size(); i++){
    float s = phi.get(i) + padd;
    float t = theta.get(i) + tadd;
    float r = radius.get(i);
    float posx = r * cos(s) * sin(t) + xadd;
    float posy = r * sin(s) * sin(t) + yadd;
    float posz = r * cos(t) + zadd;
    stroke(0,255,255);
    strokeWeight(5);
    point(posx,posy,posz);
    myMessage.add("/vicon/marker/Object/Object" + i);
    myMessage.add(posx);
    myMessage.add(posy);
    myMessage.add(posz);
  }
  
  oscP5.send(myMessage, myRemoteLocation); 
  
}
